package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.usermgmt.messages.EmployeeManagementMessages;
import gov.va.med.mhv.usermgmt.service.delegate.EmployeeSearchServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import junit.framework.TestCase;

import org.tigris.atlas.messages.Message;

public class TestEmployeeSearchService extends TestCase {

	public void testSearchByUserName() throws Exception {
		EmployeeSearchServiceDelegate employeeSearchService = ServiceDelegateFactory.createEmployeeSearchServiceDelegate();
		EmployeeSearchResultServiceResponse response = employeeSearchService.searchByUserName("vhaishmhvsa");  //this is our service account, it will exist.
		boolean hasErrors = response.getMessages().hasErrorMessages() || response.getEmployeeSearchResult().getMessages().hasErrorMessages();
		assertFalse( hasErrors );
	}
	
	public void testSearchByLastName() throws Exception {
		EmployeeSearchServiceDelegate employeeSearchService = ServiceDelegateFactory.createEmployeeSearchServiceDelegate();
		EmployeeSearchResultCollectionServiceResponse response = employeeSearchService.searchByName(null,"Smith"); //this is such a common name, it is assumed to exist
		boolean hasErrors = response.getMessages().hasErrorMessages();
		assertFalse( hasErrors );
		assertTrue(response.getEmployeeSearchResults().size() > 0);
	}
	
	public void testSearchByUserNameNoResults() throws Exception {
		EmployeeSearchServiceDelegate employeeSearchService = ServiceDelegateFactory.createEmployeeSearchServiceDelegate();
		EmployeeSearchResultCollectionServiceResponse response = employeeSearchService.searchByName(null,"asdfasdvasdfwaesdfcasdcasdfawe");
		assertFalse( response.getMessages().hasErrorMessages() );
		boolean hasInfo = response.getMessages().hasInformationalMessages();
		assertTrue( hasInfo );
		Message m = (Message) response.getMessages().getInformationalMessages().iterator().next();
		assertEquals( EmployeeManagementMessages.SEARCH_NO_RESULTS, m.getKey() );
	}
	
	public void testSearchByLastNameNoResults() throws Exception {
		EmployeeSearchServiceDelegate employeeSearchService = ServiceDelegateFactory.createEmployeeSearchServiceDelegate();
		EmployeeSearchResultCollectionServiceResponse response = employeeSearchService.searchByName(null,"adfasdvasdfwefasdcasdcasedrfasd");
		assertFalse( response.getMessages().hasErrorMessages() );
		boolean hasInfo = response.getMessages().hasInformationalMessages();
		assertTrue( hasInfo );
		Message m = (Message) response.getMessages().getInformationalMessages().iterator().next();
		assertEquals( EmployeeManagementMessages.SEARCH_NO_RESULTS, m.getKey() );
	}
}
